<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;

class JenkinsSuspend
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(SuspendSite $event)
    {

        //Account Suspend or UnSuspend
        $this->cwp->newRequest('account', [
            'action' => ($event->getStatus() === "true") ? 'susp' : 'unsp',
            'user' => $event->getSite()->assign->username,
        ]);

//        $this->site->newRequest([
//            'subDomain' => $event->getSite()->subdomain_name,
//            'suspend' => $event->getStatus(),
//        ]);


        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'suspend' => $event->getStatus(),
        ]);

    }
}
