<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;

class JenkinsDelete
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(DeleteSite $event)
    {
        //Delete Account
        $this->cwp->newRequest('account', [
            'action' => 'del',
            'user' => $event->getSite()->subdomain_name,
            'email' => $event->getSite()->assign->email,
        ]);

        //Delete SSL
        $this->cwp->newRequest('autossl', [
            'action' => 'del',
            'user' => $event->getSite()->subdomain_name,
            'name' => $event->getSite()->subdomain_name . ".openclassify.com",
        ]);

        //Jenkins Delete
//        $this->site->newRequest([
//            'subDomain' => $event->getSite()->subdomain_name,
//            'delete' => "true",
//        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'delete' => "true",
        ]);

    }
}
