<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;

class JenkinsAddAddon
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(AddAddonSite $event)
    {
        $addon = explode('_', $event->getAdvSlug());
        $this->site->newRequest([
            'userCWP' => $event->getSite()->subdomain_name,
            'addon_name' => array_first($addon),
            'addon_type' => end($addon),
        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'addon' => true,
            'addonName' => array_first($addon),
            'addonType' => end($addon),
        ]);

    }
}
