<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;

class JenkinsDelete
{
    private $cwp;

    public function __construct(TaskRepositoryInterface $cwp)
    {
        $this->cwp = $cwp;
    }

    public function handle(DeleteSite $event)
    {
        //Delete Account
        $response = $this->cwp->newRequest('account',null,$event->getSite()->node, [
            'action' => 'del',
            'user' => $event->getSite()->subdomain_name
        ]);

        $response = isset($response->response) ? json_decode($response->response, true) : $response;

        if (isset($response['status']) && $response['status'] == "OK") {
            return ['status' => true];
        }
        return ['status' => false, 'message' => $response['msj']];
    }
}
