<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateSite;

class JenkinsCreate
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(CreateSite $event)
    {


        $response = $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'newInstallation' => "true",
            'adminUserName' => $event->getAssign()->username,
            'adminPass' => $event->getSite()->password,
            'adminEmail' => $event->getAssign()->email
        ]);

        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/', $response_link)));
        $response_id = end($response_params);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'email' => $event->getAssign()->email,
            'username' => $event->getAssign()->username,
            'password' => $event->getSite()->password,
            'create' => true,
            'queueId' => $response_id,
        ]);

    }
}
