<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;

class JenkinsSuspend
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(SuspendSite $event)
    {

        //Account Suspend or UnSuspend
        $response = $this->cwp->newRequest('account',null,$event->getSite()->node, [
            'action' => ($event->getStatus() === "true") ? 'susp' : 'unsp',
            'user' => $event->getSite()->subdomain_name,
        ]);

        if ($response->status) {
            return ['status' => true];
        }
        return [
            'status' => false,
            'message' => json_decode($response->response, true)['msj']
        ];

    }
}
