<?php namespace Visiosoft\SiteMethodJenkinsModule\Listener;

use Visiosoft\CloudsiteModule\Site\Event\AddDomainSite;

class JenkinsAddDomainSite
{
    public function handle(AddDomainSite $event)
    {
        $username = $event->settings->value('visiosoft.module.site_method_jenkins::username');
        $token = $event->settings->value('visiosoft.module.site_method_jenkins::token');
        $url = $event->settings->value('visiosoft.module.site_method_jenkins::url');
        $token_parameter = $event->settings->value('visiosoft.module.site_method_jenkins::token_parameter');

        $endpoint = "http://".$username.":".$token."@".$url;

        $client = new \GuzzleHttp\Client();

        $subDomain = $event->request['subdomain'];
        $Domain = $event->request['domain'];

        $response = $client->request('POST', $endpoint, ['query' => [
            'token' => $token_parameter,
            'subDomain' => $subDomain,
            'domain' => $Domain,
        ]]);
    }
}
