<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\BuildSubSite;

class JenkinsCreateSubSite
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(BuildSubSite $event)
    {
        try {
            $app = $event->getApp();

            $endpoint = "https://" . setting_value('visiosoft.module.jenkins::username') . ":" .
                setting_value('visiosoft.module.jenkins::token') . "@" .
                'jenkins.visiosoft.com.tr/job/Siteclassified/buildWithParameters';

            $response = $this->site->newRequest([
                'app' => $app->username(),
                'domain' => $event->getSubdomain() . "." . $event->getType(),
                'subdomain' => $event->getSubdomain(),
                'node' => $app->getServer(),
                'username' => $event->getUser()->username,
                'locale' => $event->getSite()->getLocale(),
                'password' => $event->getPassword(),
                'email' => $event->getUser()->email,
            ], setting_value('visiosoft.module.jenkins::token_parameter'), $endpoint);

            $response_link = $response->getHeader('Location')[0];
            $response_params = array_values(array_filter(explode('/', $response_link)));
            $response_id = end($response_params);

            $this->site->create([
                'subdomain' => $event->getSubdomain(),
                'email' => $event->getUser()->email,
                'username' => $event->getUser()->username,
                'password' => $event->getPassword(),
                'create' => true,
                'queueId' => $response_id,
            ]);

            return ['status' => true];

        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage()];
        }
    }
}
