<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\UpdateSite;

class JenkinsUpdate
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(UpdateSite $event)
    {
        $response = $this->site->newRequest([
            'userCWP' => $event->getSite()->subdomain_name,
            'node' => $event->getSite()->getServer(),
        ]);

        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/', $response_link)));
        $response_id = end($response_params);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'update' => true,
            'queueId' => $response_id,
        ]);

    }
}
