<?php namespace Visiosoft\SiteMethodJenkinsModule\Listener;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\CloudsiteModule\Site\Event\CreateSite;
use Visiosoft\CloudsiteModule\Site\SiteModel;

class JenkinsCreate
{
    public function handle(CreateSite $event)
    {
        $username = $event->settings->value('visiosoft.module.site_method_jenkins::username');
        $token = $event->settings->value('visiosoft.module.site_method_jenkins::token');
        $url = $event->settings->value('visiosoft.module.site_method_jenkins::url');
        $token_parameter = $event->settings->value('visiosoft.module.site_method_jenkins::token_parameter');

        $endpoint = "http://".$username.":".$token."@".$url;

        $client = new \GuzzleHttp\Client();

        $newInstallation = "true";
        $subDomain = $event->request['subdomain'];

        $response = $client->request('POST', $endpoint, ['query' => [
            'token' => $token_parameter,
            'newInstallation' => $newInstallation,
            'subDomain' => $subDomain,
            'adminUserName' => $event->request['username'],
            'adminPass' => $event->request['password'],
            'adminEmail' => $event->request['email']
        ]]);
        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/',$response_link)));
        $response_id = end($response_params);

        $siteModel = new SiteModel();
        $siteModel->updateBySubdomain($subDomain,['response_id' => $response_id]);
    }
}
