<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;

class JenkinsCheckActivated
{
    /**
     * @var SiteRepositoryInterface
     */
    private $site;

    /**
     * JenkinsCheckActivated constructor.
     * @param SiteRepositoryInterface $site
     */
    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    /**
     * @param CheckActivatedSite $event
     * @return mixed
     */
    public function handle(CheckActivatedSite $event)
    {
        $jenkins_log = $this->site->newQuery()
            ->where('subdomain', $event->getSite()
                ->subdomain_name)->orderByDesc('id')->first();

        if ($jenkins_log) {
            $rID = $jenkins_log->queueId;
            $response = $this->site->checkStatusRequest($rID);

            if ($response and isset($response['result']) and $response['result'] == "SUCCESS") {
                return true;
            }
        }
        return false;
    }
}
