<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteAddonSite;

class JenkinsDeleteAddon
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(DeleteAddonSite $event)
    {
        $addon = explode('-', $event->getAddon()->addon);
        $response = $this->site->newRequest([
            'userCWP' => $event->getSite()->subdomain_name,
            'node' => $event->getSite()->getServer(),
            'addon_name' => array_first($addon),
            'addonremove' => "true",
        ]);

        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/', $response_link)));
        $response_id = end($response_params);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'addon' => true,
            'addonName' => array_first($addon),
            'addonType' => end($addon),
            'delete' => true,
            'queueId' => $response_id,
        ]);

    }
}
