<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;

class JenkinsAddMultipleAddon
{
    protected $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(AddMultipleAddonSite $event)
    {
        $addon_array = json_encode($event->getAddonArray());

        $response = $this->site->newRequest([
            'userCWP' => $event->getSite()->subdomain_name,
            'node' => $event->getSite()->getServer(),
            'addonarray' => $addon_array,
        ]);

        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/', $response_link)));
        $response_id = end($response_params);

        foreach ($event->getAddonArray() as $addon)
        {
            $this->site->create([
                'subdomain' => $event->getSite()->subdomain_name,
                'addon' => true,
                'addonName' => $addon['name'],
                'addonType' => $addon['type'],
                'queueId' => $response_id,
            ]);
        }

        return true;
    }
}
