<?php namespace Visiosoft\IoncubeModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\IoncubeModule\Encryption\Contract\EncryptionRepositoryInterface;
use Visiosoft\IoncubeModule\Encryption\EncryptionRepository;
use Anomaly\Streams\Platform\Model\Ioncube\IoncubeEncryptionEntryModel;
use Visiosoft\IoncubeModule\Encryption\EncryptionModel;
use Visiosoft\IoncubeModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\IoncubeModule\Addon\AddonRepository;
use Anomaly\Streams\Platform\Model\Ioncube\IoncubeAddonEntryModel;
use Visiosoft\IoncubeModule\Addon\AddonModel;
use Illuminate\Routing\Router;

class IoncubeModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/ioncube' => 'Visiosoft\IoncubeModule\Http\Controller\Admin\EncryptionController@index',
        'admin/ioncube/encrypt-modules/{id}' => 'Visiosoft\IoncubeModule\Http\Controller\Admin\EncryptionController@make',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\IoncubeModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\IoncubeModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\IoncubeModule\Event\ExampleEvent::class => [
        //    Visiosoft\IoncubeModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\IoncubeModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        IoncubeEncryptionEntryModel::class => EncryptionModel::class,
        IoncubeAddonEntryModel::class => AddonModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        EncryptionRepositoryInterface::class => EncryptionRepository::class,
        AddonRepositoryInterface::class => AddonRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
