<?php namespace Visiosoft\IoncubeModule\Encryption\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Carbon\Carbon;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class EncryptionTableButtons
{
    public function handle(EncryptionTableBuilder $builder)
    {
        $builder->setButtons([
            'download' => [
                'href' => function (EntryInterface $entry) {
                    if ($site = $entry->site) {
                        $token = Carbon::make($entry->created_at)->format('U');
                        return setting_value('visiosoft.module.ioncube::ioncube_download_url') . $site->api_token . $token.'.zip';
                    }
                    return '#';
                },
                'text' => 'visiosoft.module.ioncube::button.download',
                'icon' => 'fa fa-save',
                'type' => 'primary'
            ],
        ]);
    }
}
