<?php namespace Visiosoft\IoncubeModule\Encryption\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\IoncubeModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\IoncubeModule\Commands\JenkinsIoncube;
use Visiosoft\IoncubeModule\Encryption\Contract\EncryptionRepositoryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\SiteModel;

class EncryptionFormHandler
{
    public function handle(EncryptionFormBuilder $builder,
                           SiteRepositoryInterface $siteRepository,
                           AddonRepositoryInterface $addonRepository,
                           EncryptionRepositoryInterface $repository,
                           MessageBag $message)
    {

        if (!$builder->canSave()) {
            return;
        }

        $site_id = $builder->getFormEntry();
        $addons = json_decode($builder->getPostValue('addons'), true);
        $domains = json_decode($builder->getPostValue('domains'), true);

        $site = $siteRepository->newQuery()->find($site_id);

        if ($site && $site->status = "completed") {

            $site_addons = [];

            foreach ($domains as $domain) {
                $domain = ["domain" => $domain['value']];
                $site_domains[] = $domain;
            }

            foreach ($addons as $addon) {
                $addon_array = explode('-', $addon['value']);
                $site_addons[] = ['type' => $addon_array[1], 'name' => $addon_array[0]];
            }

            $api_token = $site->api_token;

            $entry = $repository->newQuery()->create([
                'site_id' => $site->id
            ]);

            $api_token .= Carbon::make($entry->created_at)->format('U');

            $builder->setFormEntry($entry);

            foreach ($site_addons as $addon) {
                $addonRepository->newQuery()->create([
                    'addon_slug' => $addon["name"] . "-" . $addon["type"],
                    'encryption_id' => $entry->id,
                    'domains' => json_encode($site_domains)
                ]);
            }

            dispatch(new JenkinsIoncube(json_encode($site_addons), json_encode($site_domains), $api_token));
        } else {
            $message->error(['Site not found or not completed!']);
        }
    }
}
