<?php namespace Visiosoft\IoncubeModule\Encryption\Form;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldRepository;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class EncryptionFormFields
{
    public function handle(EncryptionFormBuilder $builder)
    {

        $buttons = [
            'addons' => [
                'label' => 'visiosoft.module.ioncube::field.addons.name',
                'type' => 'anomaly.field_type.tags',
                'value' => function (AddonRepositoryInterface $addonRepository) use ($builder) {
                    $site_id = $builder->getFormEntry();

                    $installed_addons = $addonRepository->newQuery()
                        ->where('subdomain_id', $site_id)
                        ->where('installed', true)
                        ->get();

                    return count($installed_addons) ? $installed_addons->pluck('addon', 'addon')->all() : [];
                },
                "config" => [
                    "options" => function (CustomFieldRepository $customFieldRepository, AdvRepositoryInterface $repository) {
                        $cf = $customFieldRepository->findBySlug('addon_composer_name');

                        if (!$cf)
                            return [];

                        $addons = $repository->newQuery()
                            ->where('slug', '!=', "")
                            ->where('cf_json', 'like', '%"cf' . $cf->id . '":%')
                            ->get();

                        $list = array();
                        foreach ($addons as $addon) {
                            $addon = $customFieldRepository->getAdValueByCustomFieldSlug('addon_composer_name', $addon->id);
                            $list[] = $addon;
                        }

                        return $list;

                    },
                ]
            ],
            'domains' => [
                'label' => 'visiosoft.module.ioncube::field.domains.name',
                'type' => 'anomaly.field_type.tags',
                'value' => function (DomainRepositoryInterface $domainRepository,
                                     SiteRepositoryInterface $siteRepository) use ($builder) {
                    $site_id = $builder->getFormEntry();

                    $site = $siteRepository->find($site_id);

                    $site_domains = $domainRepository->newQuery()
                        ->where('subdomain_id', $site_id)
                        ->get();

                    $domains = [$site->getUrl()];

                    if ($site_domains)
                        $domains = array_merge($domains, $site_domains->pluck('domain')->all());

                    return $domains;
                }
            ],
        ];

        $builder->setFields($buttons);
    }
}
