<?php namespace Visiosoft\IoncubeModule\Commands;

class JenkinsIoncube
{
    protected $addon_array;
    protected $domain_array;
    protected $site_token;

    public function __construct($addon_array, $domain_array, $site_token)
    {
        $this->site_token = $site_token;
        $this->addon_array = $addon_array;
        $this->domain_array = $domain_array;
    }

    public function handle()
    {
        $endpoint = setting_value('visiosoft.module.ioncube::endpoint','https://auto:11e12c4305458f4414ef1a54ae6465822f@ci.visiosoft.com.tr/job/ioncube%20encrypter/buildWithParameters');

        $params = [
            'addonArray' => $this->addon_array,
            'domainArray' => $this->domain_array,
            'siteToken' => $this->site_token
        ];

        $client = new \GuzzleHttp\Client(['verify' => false]);

        $response = $client->request('POST', $endpoint, ['query' => $params]);

        return $response;

    }
}
