<?php namespace Visiosoft\InterestsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\InterestsModule\Userinterest\Contract\UserinterestRepositoryInterface;
use Visiosoft\InterestsModule\Userinterest\UserinterestRepository;
use Anomaly\Streams\Platform\Model\Interests\InterestsUserinterestsEntryModel;
use Visiosoft\InterestsModule\Userinterest\UserinterestModel;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;
use Visiosoft\InterestsModule\Interest\InterestRepository;
use Anomaly\Streams\Platform\Model\Interests\InterestsInterestEntryModel;
use Visiosoft\InterestsModule\Interest\InterestModel;
use Illuminate\Routing\Router;

class InterestsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        InterestsModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/interests/userinterests' => 'Visiosoft\InterestsModule\Http\Controller\Admin\UserinterestsController@index',
        'admin/interests/userinterests/create' => 'Visiosoft\InterestsModule\Http\Controller\Admin\UserinterestsController@create',
        'admin/interests/userinterests/edit/{id}' => 'Visiosoft\InterestsModule\Http\Controller\Admin\UserinterestsController@edit',
        'admin/interests' => 'Visiosoft\InterestsModule\Http\Controller\Admin\InterestController@index',
        'admin/interests/create' => 'Visiosoft\InterestsModule\Http\Controller\Admin\InterestController@create',
        'admin/interests/edit/{id}' => 'Visiosoft\InterestsModule\Http\Controller\Admin\InterestController@edit',
        'interests' => [
            'as' => 'interests',
            'middleware' => 'auth',
            'uses' => 'Visiosoft\InterestsModule\Http\Controller\InterestController@index',
        ],
        'interest/ajax/add/{id}' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\InterestsModule\Http\Controller\InterestController@addAjax',
        ],
        'interest/ajax/remove/{id}' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\InterestsModule\Http\Controller\InterestController@removeAjax',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\InterestsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\InterestsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\InterestsModule\Event\ExampleEvent::class => [
        //    Visiosoft\InterestsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\InterestsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        InterestsUserinterestsEntryModel::class => UserinterestModel::class,
        InterestsInterestEntryModel::class => InterestModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserinterestRepositoryInterface::class => UserinterestRepository::class,
        InterestRepositoryInterface::class => InterestRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
