<?php namespace Visiosoft\InterestsModule\Userinterest;

use Visiosoft\InterestsModule\Userinterest\Contract\UserinterestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserinterestRepository extends EntryRepository implements UserinterestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var UserinterestModel
     */
    protected $model;

    /**
     * Create a new UserinterestRepository instance.
     *
     * @param UserinterestModel $model
     */
    public function __construct(UserinterestModel $model)
    {
        $this->model = $model;
    }

    public function findInterestByUser($user_id)
    {
        return $this->newQuery()->where('user_id', $user_id)->orderByDesc('id')->first();
    }
}
