<?php namespace Visiosoft\InterestsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\InterestsModule\Events\UserInterestsWasCreated;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;

class InterestController extends ResourceController
{
    protected $repository;

    public function __construct(InterestRepositoryInterface $repository)
    {
        $this->repository = $repository;
        parent::__construct();
    }

    public function index()
    {
        if($this->request->has('save'))
        {
            $this->messages->success(trans('module::message.update_success'));
        }
        return $this->view->make('visiosoft.module.interests::edit');
    }


    public function addAjax()
    {
        $status = false;

        if (request()->has(['id', 'parent'])) {
            $id = request()->get('id');
            $parent_id = request()->get('parent');

            // Check if first interest
            if (!$isFirstInterests = $this->repository->isFirstInterest()) {
                event(new UserInterestsWasCreated(\auth()->id()));
            }

            if (!$this->repository->findCategoryByUser($id, Auth::id())) {
                $this->repository->createByUser(Auth::id(), $id, $parent_id);

                $status = true;
            }
        }
        return response()->json(['status' => $status]);
    }

    public function removeAjax()
    {
        $status = false;
        if(request()->has('id'))
        {
            $id = request()->get('id');
            if ($interest = $this->repository->findCategoryByUser($id, Auth::id())) {
                $interest->delete();
                $status = true;
            }
        }
        return response()->json(['status' => $status]);
    }
}
