<?php namespace Visiosoft\InterestsModule\Interest;

use Illuminate\Support\Facades\DB;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class InterestRepository extends EntryRepository implements InterestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var InterestModel
     */
    protected $model;

    /**
     * Create a new InterestRepository instance.
     *
     * @param InterestModel $model
     */
    public function __construct(InterestModel $model)
    {
        $this->model = $model;
    }

    public function getInterestsCategory()
    {
        return $this->newQuery()->select('category_id')
            ->groupBy('category_id')->pluck('category_id')->all();
    }

    public function getInterestsByCategory($id)
    {
        return $this->newQuery()->where('category_id', $id)->get();
    }
}
