<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleInterestsCreateInterestsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'category' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'search',
                'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
            ],
        ],
        'interests' => [
            'type' => 'anomaly.field_type.multiple',
            'config' => [
                'related' => \Visiosoft\InterestsModule\Interest\InterestModel::class,
            ],
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'lookup',
                'related' => \Anomaly\UsersModule\User\UserModel::class,
            ],
        ],
    ];

}
