<?php namespace Visiosoft\InterestsModule\Interest;

use Illuminate\Support\Facades\DB;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class InterestRepository extends EntryRepository implements InterestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var InterestModel
     */
    protected $model;

    /**
     * Create a new InterestRepository instance.
     *
     * @param InterestModel $model
     */
    public function __construct(InterestModel $model)
    {
        $this->model = $model;
    }

    public function getInterestsWithParentByUser($parent_id, $user_id)
    {
        return $this->newQuery()
            ->where('user_id', $user_id)
            ->where('parent_category_id', $parent_id)
            ->get();
    }

    public function findCategoryByUser($id, $user_id)
    {
        return $this->newQuery()
            ->where('user_id', $user_id)
            ->where('category_id', $id)
            ->first();
    }

    public function createByUser($user_id, $category_id, $parent_id)
    {
        return $this->create([
            'user_id' => $user_id,
            'category_id' => $category_id,
            'parent_category_id' => $parent_id,
        ]);
    }
}
