<?php namespace Visiosoft\InterestsModule\Interest;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class Export implements WithMapping, FromCollection, WithHeadings
{

    public function collection()
    {
        $interests = new InterestModel();

        $in = $interests->newQuery()->join('cats_category_translations as category_translations', function ($join) {
            $join->on('category_id', '=', 'category_translations.entry_id');
            $join->where('category_translations.locale', '=', Request()->session()->get('_locale', setting_value('streams::default_locale', 'en')));
        });

        $in = $in->rightJoin('users_users as users', 'user_id', 'users.id');

        return $in->select(['users.*', 'category_translations.name as name', DB::raw("group_concat(name SEPARATOR ', ') as tags")])
            ->groupBy('user_id')
            ->get();
    }

    public function map($interests): array
    {
        return [
            $interests->email,
            $interests->username,
            $interests->first_name,
            $interests->last_name,
            $interests->display_name,
            $interests->ip_address,
            $interests->country_id,
            $interests->city,
            $interests->district,
            $interests->neighborhood,
            $interests->village,
            $interests->gsm_phone,
            $interests->land_phone,
            $interests->office_phone,
            $interests->phone_number,
            $interests->register_type,
            $interests->identification_number,
            $interests->created_at,
            $interests->tags,
        ];
    }

    public function headings(): array
    {
        return [
            'email address',
            'username',
            'first_name',
            'last_name',
            'display_name',
            'ip_address',
            'country_id',
            'city',
            'district',
            'neighborhood',
            'village',
            'gsm_phone',
            'land_phone',
            'office_phone',
            'phone_number',
            'register_type',
            'identification_number',
            'created_at',
            'TAGS',
        ];
    }
}
