<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleInterestsCreateInterestStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'interest',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'parent_category' => [
            'required' => true,
        ],
        'category' => [
            'required' => true,
        ],
        'user' => [
            'required' => true,
        ],
    ];

}
