<?php namespace Visiosoft\InterestsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;

class InterestsModulePlugin extends Plugin
{
    public $interest;

    public function __construct(InterestRepositoryInterface $interest)
    {
        $this->interest = $interest;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getInterestsWithParentByUser',
                function ($parent_id, $user_id) {
                    if (!$interests = $this->interest->getInterestsWithParentByUser($parent_id, $user_id)) {
                        return null;
                    }
                    return $interests;
                }
            ),
        ];
    }
}
