<?php namespace Visiosoft\InterestsModule\Interest\Form;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class InterestFormHandler
{

    public function handle(InterestFormBuilder $builder, CategoryRepositoryInterface $categoryRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $category_id = $builder->getPostValue('category');

        $category = $categoryRepository->find($category_id);

        $builder->saveForm();

        if ($parent = $category->getParent()) {

            $entry = $builder->getFormEntry();

            $entry->parent_category_id = $parent->id;

            $entry->save();
        }

    }
}
