<?php namespace Visiosoft\InterestsModule\Interest\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class InterestFormFields
{

    public function handle(InterestFormBuilder $builder)
    {
        $builder->setFields([
            'user',
            'category' => [
                "config" => [
                    "handler" => function (RelationshipFieldType $fieldType, CategoryRepositoryInterface $category) {
                        $categories = $category->mainCats()->pluck('id');

                        $sub_categories = array();
                        foreach ($categories as $main_category) {
                            if (count($sub_category = $category->getSubCatById($main_category))) {
                                $sub_categories += $sub_category->pluck('name', 'id')->all();
                            }
                        }
                        $fieldType->setOptions($sub_categories);
                    }
                ]
            ],
        ]);
    }
}
