//Add Interests
$('.interest-content').on('click', '.passive-area > .interest-item', function (e) {
    e.stopPropagation()
    var item = $(this);
    editInterests(item, add_interest_url)
});


//Remove Interests
$('.interest-content').on('click', '.active-area > .interest-item', function (e) {
    e.stopPropagation()
    var item = $(this);
    editInterests(item, remove_interest_url)
});

function editInterests(item, url) {
    var id = item.data('id');
    var category = item.data('category');

    crudAjax({'parent': category, 'id': id}, url, 'POST', function (e) {
        if (e.status) {
            var count_area = $('.count[data-category="' + category + '"]');
            count_area.html(e.data.active.length);
            $('.interest-area[data-parent="' + category + '"]').html(createActiveHtml(category, e.data.active) + createPassiveHtml(category, e.data.passive));
        }
    });
}


$.ajax({
    type: 'GET',
    async: false,
    url: my_interests_api_url,
    success: function (response) {
        $.each(response, function (index, value) {
            $('.interest-content').append(getCategegoryHtml(value));
        })
    }
});


function getCategegoryHtml(category) {
    return `<div class="w-100 mx-0 row justify-content-between mt-3">
            <div class="col-3 d-none d-md-flex text-left title-interests py-2 pl-4 mb-2 bg-white shadow-sm item-category">
                    <span class="text-truncate">
                        ` + category.name + `
                    </span>
            </div>
            <div class="col-12 col-md-9 text-left item-interest title-interests bg-white py-2 pl-4 mb-2 shadow-sm">
                <div data-toggle="dropdown" class="d-flex justify-content-between">
                        <span class="d-none d-md-block ">
                                <strong class="count mr-1" data-category="` + category.id + `">
                                    ` + category.active.length + `
                                </strong>
                                <span>
                                  ` + selection_made + `
                                </span>
                        </span>
                        <span class="d-block d-md-none text-dark">` + category.name + `</span>
                        <i class="fa fa-caret-down text-dark pt-1 pr-3"></i>
                </div>

                <ul class="dropdown-menu shadow-sm interest-dropdown">
                    <div class="w-100 d-flex justify-content-between select-item-title-dropdown">
                         <span class="d-none d-md-block">
                               <strong class="count mr-1" data-category="` + category.id + `">
                                    ` + category.active.length + `
                               </strong>
                               <span>` + selection_made + `</span>
                         </span>
                         <span class="d-block d-md-none text-dark">` + category.name + `</span>
                         <i class="fa fa-caret-down text-dark pt-1 pr-2"></i>
                    </div>
                    <div class="bg-white rounded py-2 px-0 col-12 interest-area" data-parent="` + category.id + `">
                    ` + createActiveHtml(category.id, category.active) + createPassiveHtml(category.id, category.passive) + `
                    </div>
                </ul>
            </div>
        </div>`;
}

function createPassiveHtml(parent_id, interests) {
    var html = `<div class="passive-area w-100 row mx-0 pt-3" data-category="` + parent_id + `">`;
    $.each(interests, function (index, value) {
        html += `<div class="interest-item py-1 pl-4 pr-2 d-flex align-items-center justify-content-between"
                      data-category="` + parent_id + `" data-id="` + value.id + `">
                    <span>` + value.name + `</span><i class="remove-interests" style="display: none"></i>
                 </div>`
    });

    return html + `</div>`;
}

function createActiveHtml(parent_id, interests) {
    var html = `<div class="active-area w-100 row mx-0 pb-3" data-category="` + parent_id + `">`;
    $.each(interests, function (index, value) {
        html += `<div class="interest-item py-1 pl-4 pr-2 interest-active d-flex align-items-center justify-content-between"
                        data-category="` + parent_id + `" data-id="` + value.id + `">
                      <span class="pr-2">` + value.name + `</span><i class="remove-interests"></i>
                 </div>`;
    });
    return html + `</div>`;
}