<?php namespace Visiosoft\InterestsModule\Userinterest;

use Anomaly\UsersModule\User\User;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class Export implements WithMapping, FromCollection, WithHeadings
{
    /**
     * @return User[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Support\Collection
     */
    public function collection()
    {
        $interests = new UserinterestModel();

        $in = $interests->newQuery()
            ->leftJoin('interests_userinterests_interests as user_interests_relation', 'interests_userinterests.id', 'user_interests_relation.entry_id')
            ->leftJoin('interests_interest as interests', 'user_interests_relation.related_id', 'interests.id');

        $in = $in->leftJoin('interests_interest_translations as interests_translations', function ($join) {
            $join->on('interests.id', '=', 'interests_translations.entry_id');
            $join->where('interests_translations.locale', '=', Request()->session()->get('_locale', setting_value('streams::default_locale', 'en')));
        });

        $in = $in->leftJoin('users_users as users', 'interests_userinterests.user_id', 'users.id');

        return $in->select(['users.*', 'interests_translations.name as name', DB::raw("group_concat(name SEPARATOR ', ') as tags")])
            ->groupBy('user_id')
            ->get();
    }

    public function map($interests): array
    {
        return [
            $interests->email,
            $interests->username,
            $interests->first_name,
            $interests->last_name,
            $interests->display_name,
            $interests->ip_address,
            $interests->country_id,
            $interests->city,
            $interests->district,
            $interests->neighborhood,
            $interests->village,
            $interests->gsm_phone,
            $interests->land_phone,
            $interests->office_phone,
            $interests->phone_number,
            $interests->register_type,
            $interests->identification_number,
            $interests->created_at,
            $interests->tags,
        ];
    }

    public function headings(): array
    {
        return [
            'email address',
            'username',
            'first_name',
            'last_name',
            'display_name',
            'ip_address',
            'country_id',
            'city',
            'district',
            'neighborhood',
            'village',
            'gsm_phone',
            'land_phone',
            'office_phone',
            'phone_number',
            'register_type',
            'identification_number',
            'created_at',
            'TAGS',
        ];
    }
}
