<?php namespace Visiosoft\InterestsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface;
use Visiosoft\InterestsModule\Userinterest\Contract\UserinterestRepositoryInterface;

class InterestsModulePlugin extends Plugin
{
    public $interest;
    public $userinterest;

    public function __construct(InterestRepositoryInterface $interest,UserinterestRepositoryInterface $userinterest)
    {
        $this->interest= $interest;
        $this->userinterest= $userinterest;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getInterestsCategory',
                function () {
                    if (!$interests = $this->interest->getInterestsCategory()) {
                        return null;
                    }
                    return $interests;
                }
            ),

            new \Twig_SimpleFunction(
                'getInterestsByCategory',
                function ($id) {
                    if (!$interests = $this->interest->getInterestsByCategory($id)) {
                        return null;
                    }
                    return $interests;
                }
            ),
            new \Twig_SimpleFunction(
                'findInterestByUser',
                function ($user_id) {
                    if (!$interests = $this->userinterest->findInterestByUser($user_id)) {
                        return null;
                    }
                    return $interests;
                }
            ),
        ];
    }
}
