<?php namespace Visiosoft\InterestsModule\Interest\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class InterestFormFields
{

    public function handle(InterestFormBuilder $builder)
    {
        $builder->setFields([
            'name',
            'slug',
            'category' => [
                "config" => [
                    "handler" => function (RelationshipFieldType $fieldType, CategoryRepositoryInterface $category) {
                        $categories = $category->mainCats()->pluck('name', 'id');
                        $fieldType->setOptions($categories->all());
                    }
                ]
            ],
        ]);
    }
}
