<?php namespace Visiosoft\InterestsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\InterestsModule\Userinterest\Contract\UserinterestRepositoryInterface;

class InterestController extends ResourceController
{

    /**
     * @var UserinterestRepositoryInterface
     */
    public $userinterest;

    /**
     * InterestController constructor.
     * @param UserinterestRepositoryInterface $userinterest
     */
    public function __construct(UserinterestRepositoryInterface $userinterest)
    {
        $this->userinterest = $userinterest;
        parent::__construct();
    }

    /**
     * @return \Illuminate\Contracts\View\View|mixed
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function index()
    {
        return $this->view->make('visiosoft.module.interests::edit');
    }

    /**
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function addAjax($id)
    {
        $interests = $this->userinterest->findInterestByUser(Auth::id());
        if (!$interests) {
            $interests = $this->userinterest->create(['user_id' => Auth::id()]);
        }
        DB::table('interests_userinterests_interests')->insert(
            ['entry_id' => $interests->id, 'related_id' => $id]
        );
        return response()->json(['status' => true]);
    }

    /**
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function removeAjax($id)
    {
        if ($interests = $this->userinterest->findInterestByUser(Auth::id())) {
            DB::table('interests_userinterests_interests')
                ->where('entry_id', $interests->id)->where('related_id', $id)
                ->delete();
            return response()->json(['status' => true]);
        }
        return response()->json(['status' => false]);
    }
}
