<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleInterestsCreateUserinterestsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'userinterests',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'interests' => [
            'required' => true,
        ],
        'user' => [
            'unique' => true,
            'required' => true,
        ],
    ];

}
