<?php

return [
    'client_id'         => [
        'required' => true,
        'env'      => 'INSTAGRAM_CLIENT_ID',
        'bind'     => 'services.instagram.client_id',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'client_secret'     => [
        'required' => true,
        'env'      => 'INSTAGRAM_CLIENT_SECRET',
        'bind'     => 'services.instagram.client_secret',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'scope'             => [
        'bind'   => 'services.instagram.scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
            ],
        ],
    ],
    'application_scope' => [
        'bind'   => 'services.instagram.application_scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
                'publish_actions',
            ],
        ],
    ],
];
