<?php namespace Visiosoft\IncomeModule\Income;

use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class IncomeRepository extends EntryRepository implements IncomeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var IncomeModel
     */
    protected $model;

    /**
     * Create a new IncomeRepository instance.
     *
     * @param IncomeModel $model
     */
    public function __construct(IncomeModel $model)
    {
        $this->model = $model;
    }

    public function createNew($item_id, $total, $date, $company_id)
    {
        return $this->create([
            'item_id' => $item_id,
            'total' => $total,
            'date' => $date,
            'company_id' => $company_id
        ]);
    }

    public function getSalesByCompanyId($id)
    {
        $groups = $this->newQuery()
            ->where('company_id', $id)
            ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
            ->where('hesap_kodu', 'like', '600%')
            ->whereRaw('LENGTH(hesap_kodu) < 8')
            ->whereRaw('LENGTH(hesap_kodu) > 3')
            ->get();

        foreach ($groups as $group) {
            $group->items = $this->newQuery()
                ->where('company_id', $id)
                ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
                ->where('hesap_kodu', 'like', $group->hesap_kodu . '%')
                ->whereRaw('LENGTH(hesap_kodu) > 6')
                ->get();
        }

        return $groups;
    }
}
