<?php namespace Visiosoft\IncomeModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\DB;
use Visiosoft\IncomeModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class IncomesController extends PublicController
{
    use PatronTrait;

    private $incomeRepository;
    private $analyticRepository;

    public function __construct(
        IncomeRepositoryInterface $incomeRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->incomeRepository = $incomeRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function detail($id)
    {
        $analytics = $this->getIncomeOrExpenseAnalytics($this->incomeRepository);

        return $this->view->make(
            'visiosoft.theme.patron::views/incomes/index', [
                'analytics'  => $analytics,
            ]
        );
    }

    public function incomeAnalysis()
    {
        $company = $this->getActiveCompany();
        $income_monthly = $this->incomeRepository->newQuery()
            ->leftJoin('income_items', 'income_incomes.item_id', 'income_items.id')
            ->select(DB::raw('sum(total) as `price`,date,item_id,name'), DB::raw('YEAR(date) year,MONTH(date) month'))
            ->whereRaw('YEAR(date) = "' . now()->format('Y') . '"')
            ->where('company_id', $company->getId())
            ->where('date', '>', (new \Carbon\Carbon)->subMonths(3))
            ->groupby('item_id', 'month')
            ->get();


        $income_array = [];
        if (count($income_monthly)) {
            foreach ($income_monthly->toArray() as $income) {
                $income_array[$income['name']]['monthly'][$income['month']] = $income;
            }
        }

        $income_yearly = $this->incomeRepository->newQuery()
            ->leftJoin('income_items', 'income_incomes.item_id', 'income_items.id')
            ->select(DB::raw('sum(total) as `price`,date,item_id,name'), DB::raw('YEAR(date) year'))
            ->where('company_id', $company->getId())
            ->where('date', '>', (new \Carbon\Carbon)->subYears(3))
            ->groupby('item_id', 'year')
            ->get();

        if (count($income_yearly)) {
            foreach ($income_yearly->toArray() as $income) {
                $income_array[$income['name']]['yearly'][$income['year']] = $income;
            }
        }

        //Calculate Total
        $total = ['month' => [], 'year' => []];
        foreach ($income_array as $income) {
            foreach ($income['monthly'] as $month_name => $month) {
                if (!isset($total['month'][$month_name])) {
                    $total['month'][$month_name] = 0;
                }
                $total['month'][$month_name] += $month['price'];
            }
            foreach ($income['yearly'] as $year_name => $year) {
                if (!isset($total['year'][$year_name])) {
                    $total['year'][$year_name] = 0;
                }
                $total['year'][$year_name] += $year['price'];
            }
        }

        //calculate percentage
        foreach ($income_array as $income_name => $income) {
            foreach ($income['monthly'] as $month_name => $month) {
                $percentage_rate = ($month['price'] * 100) / $total['month'][$month_name];
                $percentage_rate = number_format($percentage_rate, 2);
                $income_array[$income_name]['item_id'] = $income_array[$income_name]['monthly'][$month_name]['item_id'];
                $income_array[$income_name]['monthly'][$month_name]['percentage_rate'] = '%' . $percentage_rate;
            }
            foreach ($income['yearly'] as $year_name => $year) {
                $percentage_rate = ($year['price'] * 100) / $total['year'][$year_name];
                $percentage_rate = number_format($percentage_rate, 2);
                $income_array[$income_name]['item_id'] = $income_array[$income_name]['yearly'][$year_name]['item_id'];
                $income_array[$income_name]['yearly'][$year_name]['percentage_rate'] = '%' . $percentage_rate;
            }
        }

        return $this->view->make('module::income-analysis', compact('income_array', 'total', 'company'));
    }
}
