<?php namespace Visiosoft\IncomeModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Income\IncomeSynonymsEntryModel;
use Visiosoft\IncomeModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\IncomeModule\Analytic\AnalyticRepository;
use Anomaly\Streams\Platform\Model\Income\IncomeAnalyticsEntryModel;
use Visiosoft\IncomeModule\Analytic\AnalyticModel;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\IncomeModule\Income\IncomeRepository;
use Anomaly\Streams\Platform\Model\Income\IncomeIncomesEntryModel;
use Visiosoft\IncomeModule\Income\IncomeModel;
use Visiosoft\IncomeModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\IncomeModule\Item\ItemRepository;
use Anomaly\Streams\Platform\Model\Income\IncomeItemsEntryModel;
use Visiosoft\IncomeModule\Item\ItemModel;
use Illuminate\Routing\Router;
use Visiosoft\IncomeModule\Synonym\Contract\SynonymRepositoryInterface;
use Visiosoft\IncomeModule\Synonym\SynonymModel;
use Visiosoft\IncomeModule\Synonym\SynonymRepository;

class IncomeModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/income/analytics' => 'Visiosoft\IncomeModule\Http\Controller\Admin\AnalyticsController@index',
        'admin/income/analytics/create' => 'Visiosoft\IncomeModule\Http\Controller\Admin\AnalyticsController@create',
        'admin/income/analytics/edit/{id}' => 'Visiosoft\IncomeModule\Http\Controller\Admin\AnalyticsController@edit',

        'admin/income/incomes' => 'Visiosoft\IncomeModule\Http\Controller\Admin\IncomesController@index',
        'admin/income/incomes/create' => 'Visiosoft\IncomeModule\Http\Controller\Admin\IncomesController@create',
        'admin/income/incomes/edit/{id}' => 'Visiosoft\IncomeModule\Http\Controller\Admin\IncomesController@edit',
        'admin/income/incomes/view-analytics/{id}' => 'Visiosoft\IncomeModule\Http\Controller\Admin\IncomesController@viewAnalytics',

        'admin/income' => 'Visiosoft\IncomeModule\Http\Controller\Admin\ItemsController@index',
        'admin/income/create' => 'Visiosoft\IncomeModule\Http\Controller\Admin\ItemsController@create',
        'admin/income/edit/{id}' => 'Visiosoft\IncomeModule\Http\Controller\Admin\ItemsController@edit',

        'incomes' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\IncomeModule\Http\Controller\IncomesController@index',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\IncomeModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\IncomeModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\IncomeModule\Event\ExampleEvent::class => [
        //    Visiosoft\IncomeModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\IncomeModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        IncomeAnalyticsEntryModel::class => AnalyticModel::class,
        IncomeIncomesEntryModel::class => IncomeModel::class,
        IncomeItemsEntryModel::class => ItemModel::class,
        IncomeSynonymsEntryModel::class => SynonymModel::class
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        AnalyticRepositoryInterface::class => AnalyticRepository::class,
        IncomeRepositoryInterface::class => IncomeRepository::class,
        ItemRepositoryInterface::class => ItemRepository::class,
        SynonymRepositoryInterface::class => SynonymRepository::class
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
