<?php namespace Visiosoft\IncomeModule\Income\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class IncomeTableBuilder extends TableBuilder
{

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'item',
        'total',
        'date' => [
            'value' => "entry.date.format('M Y')",
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'view_analytics' => [
            'type' => 'info',
            'href' => 'admin/income/incomes/view-analytics/{entry.id}',
        ],
        'edit',
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

}
