<?php namespace Visiosoft\IncomeModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\IncomeModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class IncomesController extends PublicController
{
    use PatronTrait;

    private $incomeRepository;
    private $analyticRepository;

    public function __construct(
        IncomeRepositoryInterface $incomeRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->incomeRepository = $incomeRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function index()
    {
        $analytics = $this->getIncomeOrExpenseAnalytics($this->incomeRepository);

        return $this->view->make(
            'visiosoft.theme.patron::views/incomes/index', [
                'analytics'  => $analytics,
            ]
        );
    }
}
