<?php namespace Visiosoft\IncomeModule\Income;

use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class IncomeRepository extends EntryRepository implements IncomeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var IncomeModel
     */
    protected $model;

    /**
     * Create a new IncomeRepository instance.
     *
     * @param IncomeModel $model
     */
    public function __construct(IncomeModel $model)
    {
        $this->model = $model;
    }

    public function createNew($item_id, $total, $date, $company_id)
    {
        return $this->create([
            'item_id' => $item_id,
            'total' => $total,
            'date' => $date,
            'company_id' => $company_id
        ]);
    }

    public function getSalesByCompanyId($id)
    {
        //Get mainGroups
        $main_groups = $this->newQuery()
            ->where('company_id', $id)
            ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
            ->where('hesap_kodu', 'like', '600.%')
            ->whereRaw('LENGTH(hesap_kodu) > 4')
            ->selectRaw('item_id ,name, substring_index(hesap_kodu, ".", 2) as hesap_kodu')
            ->orderByDesc('item_id')
            ->get()->pluck('name', 'hesap_kodu')->all();

        foreach ($main_groups as $main_group_code => $main_group_name) {

            //Set name mainGroup
            $main_groups[$main_group_code] = ['name' => $main_group_name];

            $sub_groups = $this->newQuery()
                ->where('company_id', $id)
                ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
                ->where('hesap_kodu', 'like', $main_group_code . '.%')
                ->whereRaw('LENGTH(hesap_kodu) > 4')
                ->selectRaw('item_id ,name, substring_index(hesap_kodu, ".", 3) as hesap_kodu')
                ->orderByDesc('item_id')
                ->get()->pluck('name', 'hesap_kodu')->all();

            //is Sub Groups
            if (count($sub_groups)) {
                foreach ($sub_groups as $sub_group_code => $sub_group_name) {

                    //Set name subGroup
                    $sub_groups[$sub_group_code] = ['name' => $sub_group_name];

                    $items = $this->newQuery()
                        ->where('company_id', $id)
                        ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
                        ->where('hesap_kodu', 'like', $sub_group_code . '.%')
                        ->whereRaw('LENGTH(hesap_kodu) > 4')
                        ->selectRaw('total, item_id, name, substring_index(hesap_kodu, ".", 4) as hesap_kodu')
                        ->orderBy('hesap_kodu', 'ASC')
                        ->get();

                    //Add 610, 611 and 612 records
                    foreach ($items as $item) {
                        $item->h601 = ($h601 = $this->findByHesapKodu($id, "601" . substr($item->hesap_kodu, 3))) ? $h601->total : 0;
                        $item->h602 = ($h602 = $this->findByHesapKodu($id, "602" . substr($item->hesap_kodu, 3))) ? $h602->total : 0;
                        $item->h610 = ($h610 = $this->findByHesapKodu($id, "610" . substr($item->hesap_kodu, 3))) ? $h610->total : 0;
                        $item->h611 = ($h611 = $this->findByHesapKodu($id, "611" . substr($item->hesap_kodu, 3))) ? $h611->total : 0;
                        $item->h612 = ($h612 = $this->findByHesapKodu($id, "612" . substr($item->hesap_kodu, 3))) ? $h612->total : 0;
                    }
                    //is Items
                    if (count($items)) {
                        //add subGroup
                        $sub_groups[$sub_group_code]['child'] = $items;
                    }
                }

                //add mainGroup
                $main_groups[$main_group_code]['child'] = $sub_groups;
            }

        }

        return $main_groups;
    }

    public function findByHesapKodu($company_id, $hesap_kodu)
    {
        return $this->newQuery()
            ->where('company_id', $company_id)
            ->leftJoin('income_items as items', 'income_incomes.item_id', 'items.id')
            ->where('hesap_kodu', $hesap_kodu)
            ->first();
    }
}
