<?php namespace Visiosoft\IncomeModule\Http\Controller\Admin;

use Carbon\Carbon;
use Visiosoft\IncomeModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\IncomeModule\Income\Form\IncomeFormBuilder;
use Visiosoft\IncomeModule\Income\Table\IncomeTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class IncomesController extends AdminController
{

    private $incomeRepository;
    private $analyticRepository;

    public function __construct(
        IncomeRepositoryInterface $incomeRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->incomeRepository = $incomeRepository;
        $this->analyticRepository = $analyticRepository;
    }

    /**
     * Display an index of existing entries.
     *
     * @param IncomeTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(IncomeTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param IncomeFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(IncomeFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param IncomeFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(IncomeFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * View an existing entry analytics.
     *
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function viewAnalytics($id)
    {
        $mainIncome = $this->incomeRepository->find($id);
        $incomes = $this->incomeRepository->newQuery()
            ->where('item_id', $mainIncome->item_id)
            ->where('date', '>', Carbon::now()->submonths(3))
            ->get()
            ->groupBy(function($date) {
                return Carbon::parse($date->date)->format('m');
            });

        $analytics = array();
        foreach ($incomes as $month => $income) {
            $analytic = $this->analyticRepository->findAllBy('income_id', $income[0]->id);
            if (count($analytic)) {
                $analytics[] = [
                    'income' => $income[0],
                    'analytics' => $analytic
                ];
            } else {
                unset($incomes[$month]);
            }
        }

        $this->template->set('show_banner', true);

        return $this->view->make(
            'module::admin/incomes/view-analytics', [
                'analytics'  => $analytics,
            ]
        );
    }
}
