<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleIncomeCreateIncomeFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        "item" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\IncomeModule\Item\ItemModel::class,
                "mode"    => "search",
            ]
        ],
        'total' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'separator' => '',
            ]
        ],
        "date" => [
            "type"   => "anomaly.field_type.datetime",
            "config" => [
                "mode"          => "date",
            ]
        ],
        "income" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related"    => \Visiosoft\IncomeModule\Income\IncomeModel::class,
                "mode"       => "search",
                "handler"    => "Visiosoft\IncomeModule\Analytic\Form\IncomeOptions@handle",
            ]
        ],
        'entity_count' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'separator' => '',
            ]
        ],
        'entity_name' => 'anomaly.field_type.text',
        "operator" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options"       => [
                    '/' => 'visiosoft.module.income::field.division',
                    '*' => 'visiosoft.module.income::field.multiplication',
                    '+' => 'visiosoft.module.income::field.addition',
                    '-' => 'visiosoft.module.income::field.subtraction',
                ],
                "default_value" => '/',
            ]
        ],
        "synonym" => "anomaly.field_type.text"
    ];

}
