<?php namespace Visiosoft\IncomeModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\IncomeModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;

class IncomesController extends PublicController
{

    private $incomeRepository;
    private $analyticRepository;

    public function __construct(
        IncomeRepositoryInterface $incomeRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->incomeRepository = $incomeRepository;
        $this->analyticRepository = $analyticRepository;
    }

    public function index()
    {
        $mainIncome = $this->incomeRepository->first();

        $analytics = array();
        if ($mainIncome) {
            $incomes = $this->incomeRepository->newQuery()
                ->where('item_id', $mainIncome->item_id)
                ->get()
                ->groupBy(function($date) {
                    return Carbon::parse($date->date)->format('m');
                });

            foreach ($incomes as $month => $income) {
                $analytic = $this->analyticRepository->findBy('income_id', $income[0]->id);
                if ($analytic) {
                    $total = $income[0]->total;
                    $entityCount = $analytic->entity_count;
                    switch ($analytic->operator) {
                        case '/':
                            $unitCost = $total / $entityCount;
                            break;
                        case '*':
                            $unitCost = $total * $entityCount;
                            break;
                        case '-':
                            $unitCost = $total - $entityCount;
                            break;
                        case '+':
                            $unitCost = $total + $entityCount;
                            break;
                    }
                    $analytic->unit_cost = round($unitCost, 2);
                    $analytics[] = [
                        'income' => $income[0],
                        'analytics' => $analytic
                    ];
                } else {
                    unset($incomes[$month]);
                }
            }
        }

        return $this->view->make(
            'visiosoft.theme.patron::views/incomes/index', [
                'analytics'  => $analytics,
            ]
        );
    }
}
