<?php namespace Visiosoft\IncomeModule\Analytic\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;

class IncomeOptions
{

    public function handle(RelationshipFieldType $fieldType, IncomeRepositoryInterface $entries) {
        $fieldType->setOptions(
            $entries->newQuery()
                ->join('income_items','income_items.id','=','income_incomes.item_id')
                ->selectRaw("CONCAT_WS('', default_income_items.name, ' - ', DATE_FORMAT(default_income_incomes.date, '%M %Y')) AS income_value, default_income_incomes.id")
                ->pluck('income_value', 'id')
                ->toArray()
        );
    }
}
