<?php namespace Visiosoft\IncomeModule\Income;

use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class IncomeRepository extends EntryRepository implements IncomeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var IncomeModel
     */
    protected $model;

    /**
     * Create a new IncomeRepository instance.
     *
     * @param IncomeModel $model
     */
    public function __construct(IncomeModel $model)
    {
        $this->model = $model;
    }

    public function createNew($item_id, $total, $date, $company_id)
    {
        return $this->create([
            'item_id' => $item_id,
            'total' => $total,
            'date' => $date,
            'company_id' => $company_id
        ]);
    }
}
