<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleIncomeCreateAnalyticsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'analytics',
        'title_column' => 'income_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'income' => [
            'required' => true,
        ],
        'entity_count' => [
            'required' => true,
        ],
        'entity_name' => [
            'required' => true,
        ],
        'operator' => [
            'required' => true,
        ],
    ];

}
