<?php namespace Visiosoft\ImportLocationModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Stream\Command\DeleteStreamTranslations;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class ImportLocationModuleSeeder extends Seeder
{

    /**
     * @var FolderRepositoryInterface
     */
    private $folderRepository;

    /**
     * @var DiskRepositoryInterface
     */
    private $diskRepository;

    /**
     * @var StreamRepositoryInterface
     */
    private $streamRepository;

    public function __construct(
        FolderRepositoryInterface $folderRepository,
        DiskRepositoryInterface $diskRepository,
        StreamRepositoryInterface $streamRepository
    )
    {
        parent::__construct();
        $this->folderRepository = $folderRepository;
        $this->diskRepository = $diskRepository;
        $this->streamRepository = $streamRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        // Check if folder exists
        $xmlFilesFolder = $this->folderRepository->findBySlug('csv_files');

        if (!$xmlFilesFolder) {
            // Delete stream if exists
            $stream = $this->streamRepository->findBySlugAndNamespace('csv_files', 'files');
            if ($stream) {
                $deleteStreamTranslations = new DeleteStreamTranslations($stream);
                $deleteStreamTranslations->handle();
                $stream->delete();
            }

            // Get disk
            $disk = $this->diskRepository->findBySlug('local');

            $this->folderRepository->create([
                'disk' => $disk,
                'name' => 'CSV Files',
                'slug' => 'csv_files',
                'description' => 'A folder for csv files.'
            ]);
        }
    }
}
