<?php namespace Visiosoft\ImportModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Model\Cats\CatsCategoryEntryTranslationsModel;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use SimpleXLSX;

class ImportController extends AdminController
{

    private $fileRepository;
    private $categoryEntryTranslationsModel;
    private $categoryRepository;
    private $advRepository;

    public function __construct(
        FileRepositoryInterface $fileRepository,
        CatsCategoryEntryTranslationsModel $categoryEntryTranslationsModel,
        CategoryRepositoryInterface $categoryRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        parent::__construct();
        $this->fileRepository = $fileRepository;
        $this->categoryEntryTranslationsModel = $categoryEntryTranslationsModel;
        $this->categoryRepository = $categoryRepository;
        $this->advRepository = $advRepository;
    }

    public function index(FormBuilder $formBuilder)
    {
        set_time_limit(0);
        if (request()->action == "create") {
            $file = $this->fileRepository->find(request()->file);

            if ($file->extension === 'xml') {
                $xml = simplexml_load_file($file->url(),'SimpleXMLElement', LIBXML_NOCDATA);
                $ads = $xml->children();
            } elseif ($file->extension === 'xls' || $file->extension === 'xlsx') {
                $pathToFolder = "/storage/streams/default/files-module/local/xml_and_excel_files/";
                $xlsx = SimpleXLSX::parse(base_path() . $pathToFolder . $file->name);
                $headerValues = $ads = [];
                foreach ($xlsx->rows() as $k => $r) {
                    if ($k === 0) {
                        $headerValues = $r;
                        continue;
                    }
                    $ads[] = array_combine($headerValues, $r);
                }
            }

            foreach ($ads as $ad) {
                $this->postAd($ad);
            }

            $this->messages->success(trans('visiosoft.module.import::message.ads_created', ['number' => count($ads)]));
            return redirect('/admin/import');
        }
        $formBuilder->setActions(['create']);
        $formBuilder->setFields([
            'file' => [
                "type"   => "anomaly.field_type.file",
                "config" => [
                    "folders"       => ["xml_and_excel_files"],
                ]
            ],
        ]);
        return $formBuilder->render();
    }

    public function postAd($ad)
    {
        // Convert to array if object
        if (gettype($ad) === 'object') {
            $ad = (array) $ad;
        }

        // Get categories
        $category = $this->getCats([(string)$ad['mainCategory'], (string)$ad['category'], (string)$ad['subCategory']]);

        $date = date('Y-m-d H:i:s');
        $data = [
            'name' => $ad['label'],
            'advs_desc' => $ad['fullDetails'],
            'price' => $ad['price1'],
            'slug' => $ad['label'] . '_' . $ad['id'],
            'is_get_adv' => true,
            'stock' => $ad['stockAmount'],
            'currency' => setting_value('streams::currency'),
            'status' => 'approved',
            'publish_at' => $date,
            'finish_at' => date('Y-m-d H:i:s', strtotime($date . ' + 60 day')),
        ];

        $adv = $this->advRepository
            ->newQuery()
            ->where('slug', 'LIKE', '%_' . $ad['id'])
            ->first();
        if (is_null($adv)) {
            $adv = $this->advRepository->create(array_merge($data, $category));
            $adImages = $this->savePhoto(
                [(string)$ad['picture1Path'], (string)$ad['picture2Path'], (string)$ad['picture3Path']],
                $adv->id
            );
            if (count($adImages) > 0) {
                $adv->update([
                    'cover_photo' => $adImages[0]->url()
                ]);
            }
        } else {
            $adv->update(array_merge($data, $category));
        }
    }

    public function getCats($categories)
    {
        $category = array();
        $noCatFound = false;
        for ($i = 0; $i < count($categories); $i++) {
            $catNumber = $i + 1;
            $cat = $this->categoryEntryTranslationsModel->newQuery()->where('name', $categories[$i])->first();
            if (is_null($cat)) {
                $cat = ['id' => null];
                $noCatFound = true;
            } else {
                $cat = $this->categoryRepository->find($cat->entry_id);
            }

            $category['cat' . $catNumber] = $cat['id'];
            if ($noCatFound) {
                break;
            }
        }

        return $category;
    }

    public function savePhoto($photosUrl, $advId)
    {
        $adImages = array();
        /* Looping through the photo's URLs and saving them */
        foreach ($photosUrl as $photoUrl) {
            if (!empty($photoUrl)) {
                $name = basename(parse_url($photoUrl)['path']);
                $curl_handle = curl_init();
                curl_setopt($curl_handle, CURLOPT_URL, $photoUrl);
                curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 2);
                curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
                $contents = curl_exec($curl_handle);
                $httpCode = curl_getinfo($curl_handle, CURLINFO_HTTP_CODE);
                curl_close($curl_handle);
                if (!($httpCode < 200 || $httpCode > 299)) {
                    $target = base_path() . "/storage/streams/default/files-module/local/images/" . $name;
                    /* Saving the photos in the local storage */
                    file_put_contents($target, $contents);
                    $file = $this->saveFileInModel($name);
                    DB::table('advs_advs_files')->insert(['file_id' => $file->id, 'entry_id' => $advId]);
                    $adImages[] = $file;
                }
            }
        }
        return $adImages;
    }

    public function saveFileInModel($filename)
    {
        return $this->fileRepository->create([
            'folder_id' => 1,
            'name' => $filename,
            'disk_id' => 1,
            'size' => 1,
            'mime_type' => "image/jpeg",
            'extension' => 1,
        ]);
    }
}
